# Simplelines 1.1 Documentation
## Basics and Commands: The Essentials
*****
Simplelines with 1.1 has about ~35-40 functions, some small, some huge, but they're all done in just one line.
So about this library: *one line instead of a hundred, write it and be free* – it's the same function, but in one line instead of ten, and even customizable! It's a developer's paradise! Today in this documentation, we'll cover all the basic functions of Simplelines.
*Simplelines can be a very useful tool for creating console utilities in C++.*
### Let's go! Fly in the sky easy-code!

## Importing the Library
In C++, Simplelines is imported with this code:

```cpp
#include "simplelines.hpp" // Import simplelines.hpp - the entire library

int main() {
    // ...your code here
    sl::example();
}
```

*IMPORTANT! Place the library file simplelines.hpp next to your program.*
Simplelines functions are called like this: `sl::example();`
This is an example; there is no actual 'example()' function in Simplelines.

## 1. Text Formatting
Many are tired of writing unsafe system() calls, and ANSI codes are hard to remember. With Simplelines, text formatting is easy.

### 1.1. Blue Text
It's really simple – write this command in your code:

```cpp
sl::blue("Hello, world!"); // Blue text "Hello, world!" without newline
// OR
sl::blue("Hello, world!\n"); // Blue text "Hello, world!" with newline
```

### 1.2. Green Text
Same as blue, but with green instead of blue:

```cpp
sl::green("Hello, world!"); // Green text "Hello, world!" without newline
// OR
sl::green("Hello, world!\n"); // Green text "Hello, world!" with newline
```

### 1.3. Yellow Text
Same as blue or green. Yellow text is yellow.

```cpp
sl::yellow("Hello, world!"); // Yellow text "Hello, world!" without newline
// OR
sl::yellow("Hello, world!\n"); // Yellow text "Hello, world!" with newline
```

### 1.4. Blinking Text
One of the "wow" effects, perfect for game text... but only in the console. =)

```cpp
sl::flashing("Hello, world!"); // Blinking text "Hello, world!" without newline
// OR
sl::flashing("Hello, world!\n"); // Blinking text "Hello, world!" with newline
```

### Note: Changing Background Color in RGB
Also in the console, changes the console background color in RGB. For example, white:

```cpp
sl::rgbBg(255, 255, 255) // 255, 255, 255 in RGB - white color.
```

### 1.5. Random Number
The last "wow" effect in the basic commands. Also only in the console.

```cpp
sl::random(10); // Random number from 0 to 10. You can change the maximum number. For example...
sl::random(100);
```

### 1.6. {Last Formatting Style} Dim/Faint Text
Not a "wow" effect, but it might seem like one. Here's how to create dim text in Simplelines:

```cpp
sl::thin("Hello, world!"); // Dim text "Hello, world!" without newline
// OR
sl::thin("Hello, world!\n"); // Dim text "Hello, world!" with newline
```

## 2. Cursor Control
In console utilities, this can be a very useful feature, because moving the cursor sequentially isn't very convenient. So you can move the cursor wherever you want.

```cpp
// Here are all the cursor control commands.
sl::returnBeginLine(); // Return to the beginning of the line
sl::borderConsole(); // Move the cursor to the far edge of the console
sl::clearConsole(); // Clear the console
sl::clearLine(); // Clear the current line
sl::hideCur(); // Hide the console cursor
sl::showCur(); // Show the console cursor
sl::NullNullCursor(); // Move the cursor to the beginning of the console
sl::oneLineDown(); // Move the cursor one line down
sl::oneLineUp(); // Move the cursor one line up
sl::oneSymLeft(); // Move the cursor one character left
sl::oneSymRight(); // Move the cursor one character right
```

The only downside is that you can't choose how many lines to move, for example, up. To move more than one line, you need to duplicate function calls:

```cpp
sl::oneLineUp(); // One line up
sl::oneLineUp(); // Another line up
```

Result: two lines up. It's unlikely, but if you need to move up or down more than 50 lines, you'll have to write 50 lines:

```cpp
sl::oneLineUp();
sl::oneLineUp();
sl::oneLineUp();
// And 47 more lines...
```

Same with other functions, but I recommend watching for updates. Maybe Simplelines will add something like this:

```cpp
sl::oneLineUp(10); // Move 10 lines up
```

But not yet. Watch for updates if you want and can write improvements and suggestions in the project comments!

## 3. {Useful} Delay Between Functions
Yes! That exists too! Instead of writing this mess:

```cpp
std::cout << "Hello!" << std::endl;
std::this_thread::sleep_for(std::chrono::seconds(1));
std::cout << "One second has passed!" << std::endl;
```

...in Simplelines it's done like this:

```cpp
std::cout << "Hello!" << std::endl;
sl::delaySec(1);
std::cout << "One second has passed!" << std::endl;
```

### 3.1. Delay: Seconds
For a delay in seconds:

```cpp
std::cout << "Hello!" << std::endl;
sl::delaySec(1); // Wait 1 second
std::cout << "One second has passed!" << std::endl;
```

### 3.2. Delay: Milliseconds
For a delay in milliseconds:

```cpp
std::cout << "Hello!" << std::endl;
sl::delayMs(100); // Wait 100 milliseconds
std::cout << "One second has passed!" << std::endl;
```
---
# Non-base: 1.1 Full Release
## 4. ASCII-graphic
### 4.1 Draw the cat in ASCII
To draw the cat in ASCII-art in console type command:

```cpp
sl::drawCAT();
```

End! Your console can show you cat in ASCII =3

### 4.2 Draw the dog in ASCII
To draw the dog in ASCII-art in console type command:

```cpp
sl::drawDOG();
```

## 5. Progress-bar
Cool function in Simplelines 1.1. You can indicate maximal percent,
which the progress bar should reach, and then continue the program.
For, for example, progress-bar maximal percent = 100.

```cpp
for(int i = 0; i <= 100; i++) { // 100 = how much percents
    sl::barBAR(i); // i = percents (on our case - 100)
    sl::delayMs(30); // Delay between # symbol
}
```

Output (example):
```plaintext
[##                   ] 25%
```
But you can configure percent. **Just don't go into a negativenumber**
**(-1 and less), otherwise the progress bar will go crazy. Probably.**
## 6. New delays: nanoseconds, microseconds, minutes, hours!
New delays for accurate calculations.
*All delays:*

```cpp
delayNanos(500); // 500 nanoseconds
delayMicros(600); // 600 microseconds
delayMins(1); // 1 minutes
delayHours(1); // 1 hour (large delay!)
```

## 7. Fast Output
Fast output for beginners in std::cout operator.
**Pluses:**

- Stable output

- For beginners, easy and simple

**Minuses:**

- Can't show variables (int, float, std::string, char, others)

- No line feed support, only via ANSI code `\n`

For fast output type command:

```cpp
fastput("Hello World") // Hello World
```
## 8. Create file in current directory (work with files, carefully use this)
To create file any format type command:
```cpp
// Example, you can edit filename and file format.
sl::objectFile("file.txt"); // create file "file.txt"
```
## 9. Textframe. EXPERIMENTAL!!!
To create textframe type this code:

```cpp
sl::textframe("Text in my frame!");
```
**IMPORTANT:** This is an experimental feature, so performance may be uneven and unpredictable. Thank you.

---
# History
On January 17th, I conceived the idea of ​​creating a library that simplifies code for programmers, as it's better than writing dozens of lines of code. It was on that day that I released a prototype test, which hasn't and won't be released online: Simplelines 1.0 Experimental Developer Release.

Version 1.0 was released on January 20th, and it already included many features, from text formatting and console cursor control to tabs and delays between functions. Truth be told, it wasn't written from scratch. It's a copy of the experimental closed version, but with added and improved features.

While the library was actively being developed but not released immediately, version 1.1 was released on January 24th, four days later, adding a huge number of features. This is a major update, as the library offered a lot:

- ASCII art in the console: a cat and a dog with different art versions;

- Delays between functions (new): minutes, hours, nanoseconds, microseconds;

- Fast output without memory leaks, limited functionality;

- Experimental feature: Text in a frame;

- Progress bar configurable using a "for" loop.

Another major update, 1.2, is planned for January 29th, featuring mathematical functions and the creation of headings and subheadings of levels 1-6 (based on tabs, not size), and lists.