// Simplelines Header-Only Library project.
// (c) Elkin Matvey, 2026.
// (c) Simplelines, 2026.
/* === SOURCE CODE === */

#ifndef SIMPLELINES_HPP
#define SIMPLELINES_HPP

#include <iostream>
#include <string>
#include <chrono>
#include <thread>
#include <cstdlib>
#include <ctime>

namespace sl {
    void srandInit() {
        std::srand(std::time(nullptr));
    }
    void random(int randomIndex) {
        static bool inited = false;
        if (!inited) {
            srandInit();
            inited = true;
        }
        std::cout << (std::rand() % randomIndex) << "\n";
    }
    void delaySec(int sec) {
        std::this_thread::sleep_for(std::chrono::seconds(sec));
    }
    void delayMs(int ms) {
        std::this_thread::sleep_for(std::chrono::milliseconds(ms));
    }
    void equalsText(std::string text, int cycleEquals, int ifNewLine) {
        std::string equals(cycleEquals, '=');
        if (ifNewLine == 1) {
            std::cout << equals << " " << text <<  " " << equals << std::endl;
        }
        else if (ifNewLine == 0) {
            std::cout << equals << " " << text <<  " " << equals;
        } else {
            std::cout << equals << " " << text <<  " " << equals;
        }
    }
    void drawLine(int size) {
        if (size < 0) {
            std::cout << "Error: Size < 0!";
            return;
        }
        std::string line(size, '-');
        std::cout << line << std::endl;
    }
    void red(std::string text2) {
        std::cout << "\e[0;31m" << text2 << "\e[0m";
    }
    void yellow(std::string text3) {
        std::cout << "\e[0;33m" << text3 << "\e[0m";
    }
    void green(std::string text4) {
        std::cout << "\e[0;32m" << text4 << "\e[0m";
    }
    void blue(std::string text4) {
        std::cout << "\e[0;34m" << text4 << "\e[0m";
    }
    void tab(std::string TabText, int TabHowMany) {
        if (TabHowMany < 0) {
            std::cout << "\n\e[0;31m[Simplelines: Error]\e[0m: ";
            std::cout << "Negative tab quantity (" << TabHowMany << ").\n";
            std::cout << "Recommended: 0 or positive number\n\n";
            return;
        }
        if (TabHowMany > 100) {
            std::cout << "\n\e[0;31m[Simplelines Library: Error]\e[0m: ";
            std::cout << "Too many tabs (" << TabHowMany << ").\n";
            std::cout << "Recommended: less than 100 tabs\n\n";
            return;
        }
        
        std::string Tabs(TabHowMany, '\t');
        std::cout << Tabs << TabText;
    }
    void Ver() {
        std::cout << "Simplelines Version: 1.0.\n(c) 2026, Elkin Matvey\n(c) 2026, Simplelines C++ Linux Library (SCLL)\n";
    }
    void returnBeginLine() {
        std::cout << "\r";
    }
    void oneLineUp() {
        std::cout << "\u001b[A";
    }
    void oneLineDown() {
        std::cout << "\u001b[B";
    }
    void oneSymRight() {
        std::cout << "\u001b[C";
    }
    void oneSymLeft() {
        std::cout << "\u001b[D";
    }
    void clearConsole() {
        std::cout << "\x1b[2J";
    }
    void borderConsole() {
        std::cout << "\x1b[9999C"; // warning: too many border
    }
    void thin(std::string thinText) {
        std::cout << "\x1b[2m" << thinText << "\e[0m";
    }
    void flashing(std::string flashText) {
        std::cout << "\x1b[5m" << flashText << "\e[0m";
    }
    void hideCur() {
        std::cout << "\x1b[?25l";
    }
    void showCur() {
        std::cout << "\x1b[?25h";
    }
    void clearLine() {
        std::cout << "\x1b[K";
    }
    void rgbBg(int red, int green, int blue) {
        std::cout << "\x1b[48;2;" << red << ";" << green << ";" << blue << "m";
    }
    void NullNullCursor() {
        std::cout << "\x1b[H";
    }
    void resetAllStyles() {
        std::cout << "\e[0m";
    }
}

#endif