// Simplelines Example: Text Formatting

#include "simplelines.hpp"

int main() {
    // Colored text
    sl::blue("Blue");
    sl::green("Green");
    sl::yellow("Yellow");
    sl::thin("Thin");
    sl::resetAllStyles(); // Reset all styles

    // Colored background
    sl::rgbBg(255, 255, 255); // White background (RGB)
    sl::resetAllStyles(); // Reset all styles

    // "Wow" effects
    sl::tab("Hello!", 1); // Tabulation (text in quotes, and 1 is the number of tabs, can be changed from 0 to 100)
    sl::flashing("I'm blinking!"); // Blinking text
    sl::equalsText("I'm wrapped in 3 '*' characters.", 3, 1); // Wrapping in characters
                                                            // In quotes: text to wrap; 3 - number of characters; 1 - add newline?
                                                            // 1 - yes, other numbers - no, but easiest to add \n in quotes after text
    sl::random(10); // Output a random number from 0 to 10 (maximum can be changed). Example change:
    //                                                                               sl::random(100) - number from 0 to 100

    sl::srandInit(); // Random initialization (optional, since random() already has initialization, but recommended).
}