# Simplelines Documentation
## Basics and Commands: The Essentials
*****
Simplelines has about 25 functions, some small, some huge, but they're all done in just one line.
So about this library: *one line instead of a hundred, write it and be free* – it's the same function, but in one line instead of ten, and even customizable! It's a developer's paradise! Today in this documentation, we'll cover all the basic functions of Simplelines.
*Simplelines can be a very useful tool for creating console utilities in C++.*
### Let's go!

## Importing the Library
In C++, Simplelines is imported with this code:

```cpp
#include "simplelines.hpp" // Import simplelines.hpp - the entire library

int main() {
    // ...your code here
}
```

*IMPORTANT! Place the library file simplelines.hpp next to your program.*
Simplelines functions are called like this: `sl::example();`
This is an example; there is no actual 'example()' function in Simplelines.

## 1. Text Formatting
Many are tired of writing unsafe system() calls, and ANSI codes are hard to remember. With Simplelines, text formatting is easy.

### 1.1. Blue Text
It's really simple – write this command in your code:

```cpp
sl::blue("Hello, world!"); // Blue text "Hello, world!" without newline
// OR
sl::blue("Hello, world!\n"); // Blue text "Hello, world!" with newline
```

### 1.2. Green Text
Same as blue, but with green instead of blue:

```cpp
sl::green("Hello, world!"); // Green text "Hello, world!" without newline
// OR
sl::green("Hello, world!\n"); // Green text "Hello, world!" with newline
```

### 1.3. Yellow Text
Same as blue or green. Yellow text is yellow.

```cpp
sl::yellow("Hello, world!"); // Yellow text "Hello, world!" without newline
// OR
sl::yellow("Hello, world!\n"); // Yellow text "Hello, world!" with newline
```

### 1.4. Blinking Text
One of the "wow" effects, perfect for game text... but only in the console. =)

```cpp
sl::flashing("Hello, world!"); // Blinking text "Hello, world!" without newline
// OR
sl::flashing("Hello, world!\n"); // Blinking text "Hello, world!" with newline
```

### Note: Changing Background Color in RGB
Also in the console, changes the console background color in RGB. For example, white:

```cpp
sl::rgbBg(255, 255, 255) // 255, 255, 255 in RGB - white color.
```

### 1.5. Random Number
The last "wow" effect in the basic commands. Also only in the console.

```cpp
sl::random(10); // Random number from 0 to 10. You can change the maximum number. For example...
sl::random(100);
```

### 1.6. {Last Formatting Style} Dim/Faint Text
Not a "wow" effect, but it might seem like one. Here's how to create dim text in Simplelines:

```cpp
sl::thin("Hello, world!"); // Dim text "Hello, world!" without newline
// OR
sl::thin("Hello, world!\n"); // Dim text "Hello, world!" with newline
```

## 2. Cursor Control
In console utilities, this can be a very useful feature, because moving the cursor sequentially isn't very convenient. So you can move the cursor wherever you want.

```cpp
// Here are all the cursor control commands.
sl::returnBeginLine(); // Return to the beginning of the line
sl::borderConsole(); // Move the cursor to the far edge of the console
sl::clearConsole(); // Clear the console
sl::clearLine(); // Clear the current line
sl::hideCur(); // Hide the console cursor
sl::showCur(); // Show the console cursor
sl::NullNullCursor(); // Move the cursor to the beginning of the console
sl::oneLineDown(); // Move the cursor one line down
sl::oneLineUp(); // Move the cursor one line up
sl::oneSymLeft(); // Move the cursor one character left
sl::oneSymRight(); // Move the cursor one character right
```

The only downside is that you can't choose how many lines to move, for example, up. To move more than one line, you need to duplicate function calls:

```cpp
sl::oneLineUp(); // One line up
sl::oneLineUp(); // Another line up
```

Result: two lines up. It's unlikely, but if you need to move up or down more than 50 lines, you'll have to write 50 lines:

```cpp
sl::oneLineUp();
sl::oneLineUp();
sl::oneLineUp();
// And 47 more lines...
```

Same with other functions, but I recommend watching for updates. Maybe Simplelines will add something like this:

```cpp
sl::oneLineUp(10); // Move 10 lines up
```

But not yet. Watch for updates if you want and can write improvements and suggestions in the project comments!

## 3. {Useful} Delay Between Functions
Yes! That exists too! Instead of writing this mess:

```cpp
std::cout << "Hello!" << std::endl;
std::this_thread::sleep_for(std::chrono::seconds(1));
std::cout << "One second has passed!" << std::endl;
```

...in Simplelines it's done like this:

```cpp
std::cout << "Hello!" << std::endl;
sl::delaySec(1);
std::cout << "One second has passed!" << std::endl;
```

### 3.1. Delay: Seconds
For a delay in seconds:

```cpp
std::cout << "Hello!" << std::endl;
sl::delaySec(1); // Wait 1 second
std::cout << "One second has passed!" << std::endl;
```

### 3.2. Delay: Milliseconds
For a delay in milliseconds:

```cpp
std::cout << "Hello!" << std::endl;
sl::delayMs(100); // Wait 100 milliseconds
std::cout << "One second has passed!" << std::endl;
```